/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.attribute.IMagicAttribute;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.weapons.IMultihandWeapon;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private static final List<EquipmentSlot> handSlots = List.of(EquipmentSlot.OFFHAND, EquipmentSlot.MAINHAND);
    @Unique
    private static final Predicate<Attribute> allNonBaseAttackAttributes = attribute -> attribute != ForgeMod.ATTACK_RANGE.get() && attribute != Attributes.f_22281_ && attribute != Attributes.f_22283_ && attribute != Attributes.f_22282_;
    @Unique
    private static final Predicate<Attribute> onlyIronAttributes = attribute -> attribute instanceof IMagicAttribute;

    @Inject(method={"updateInvisibilityStatus"}, at={@At(value="TAIL")})
    public void updateInvisibilityStatus(CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (self.m_21023_((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get())) {
            self.m_6842_(true);
        }
    }

    @Inject(method={"getArmorCoverPercentage"}, at={@At(value="HEAD")}, cancellable=true)
    public void getArmorCoverPercentage(CallbackInfoReturnable<Float> cir) {
        if (((LivingEntity)this).m_21023_((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get())) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"isCurrentlyGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    public void isCurrentlyGlowing(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self = (LivingEntity)this;
        if (!self.f_19853_.m_5776_() && self.m_21023_((MobEffect)MobEffectRegistry.GUIDING_BOLT.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Shadow
    abstract ItemStack m_21244_(EquipmentSlot var1);

    @Inject(method={"collectEquipmentChanges"}, at={@At(value="RETURN")})
    public void handleEquipmentChanges(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> cir) {
        Map changedEquipment = (Map)cir.getReturnValue();
        if (changedEquipment == null) {
            return;
        }
        LivingEntity self = (LivingEntity)this;
        for (EquipmentSlot slot : handSlots) {
            ItemStack currentStack = (ItemStack)changedEquipment.get(slot);
            if (currentStack == null) continue;
            ItemStack oldStack = this.m_21244_(slot);
            boolean selected = currentStack.m_41720_() instanceof IMultihandWeapon;
            boolean deselected = oldStack.m_41720_() instanceof IMultihandWeapon;
            if (!selected && !deselected) continue;
            if (slot == EquipmentSlot.MAINHAND) {
                ItemStack offhandStack = self.m_21206_();
                if (!(offhandStack.m_41720_() instanceof IMultihandWeapon) || ItemStack.m_41746_((ItemStack)offhandStack, (ItemStack)currentStack)) continue;
                if (selected) {
                    self.m_21204_().m_22161_(LivingEntityMixin.filterApplicableAttributes((Multimap<Attribute, AttributeModifier>)offhandStack.m_41638_(EquipmentSlot.MAINHAND)));
                }
                if (!deselected) continue;
                self.m_21204_().m_22178_(LivingEntityMixin.filterApplicableAttributes((Multimap<Attribute, AttributeModifier>)offhandStack.m_41638_(EquipmentSlot.MAINHAND)));
                continue;
            }
            if (slot != EquipmentSlot.OFFHAND) continue;
            ItemStack mainhandStack = self.m_21205_();
            if (selected && !(mainhandStack.m_41720_() instanceof IMultihandWeapon)) {
                self.m_21204_().m_22178_(LivingEntityMixin.filterApplicableAttributes((Multimap<Attribute, AttributeModifier>)currentStack.m_41638_(EquipmentSlot.MAINHAND)));
            }
            if (!deselected || ItemStack.m_41746_((ItemStack)mainhandStack, (ItemStack)oldStack)) continue;
            self.m_21204_().m_22161_(LivingEntityMixin.filterApplicableAttributes((Multimap<Attribute, AttributeModifier>)oldStack.m_41638_(EquipmentSlot.MAINHAND)));
        }
    }

    @Unique
    private static Multimap<Attribute, AttributeModifier> filterApplicableAttributes(Multimap<Attribute, AttributeModifier> attributeModifierMap) {
        HashMultimap map = HashMultimap.create();
        for (Attribute attribute : attributeModifierMap.keySet()) {
            Predicate<Attribute> predicate = (Boolean)ServerConfigs.APPLY_ALL_MULTIHAND_ATTRIBUTES.get() != false ? allNonBaseAttackAttributes : onlyIronAttributes;
            if (!predicate.test(attribute)) continue;
            map.putAll((Object)attribute, (Iterable)attributeModifierMap.get((Object)attribute));
        }
        return map;
    }
}

